/*
 * SimpleModbusRtu_mega2560.h
 *
 *  Created on: 2019. 4. 12.
 *      Author: user
 */

#ifndef SIMPLEMODBUSRTU_MEGA2560_H_
#define SIMPLEMODBUSRTU_MEGA2560_H_

#define u8 unsigned char
#define u16 unsigned short
#define XTAL 16000000

#include "Arduino.h"
#include "Print.h"
#include <avr/io.h>  //get header file
#include <avr/wdt.h>
#include <avr/interrupt.h>


/*============================================================



  AVR GCC Simple Modbus



=============================================================*/

//  : ŵ͸  ϴ . Լ ť .

#define __ring_buffer_max 40
#define __modbusReturnInterval 1

u8 __ring_buffer[__ring_buffer_max];
u16 __save_pointer=0;
u16 __action_pointer=__ring_buffer_max-1;

u8 __modbusSwitch=0;       //   1  SimpleModbus ۽.
u16 __modbusBlankCheck = 0;

u8 __modbusSlaveAdr=0;
u16 * __modbusWordBuffer;
u8 * __modbusBitBuffer;
u8 __modbusBroadMode = 0;
u8 __modbusFoundFrame = 0;
u16 __modbusIntervalCounter=0;;
u8 uchCRCHi, uchCRCLo;
u16 uINDEX;

static u8 MDcoil[20];       // Ʈ 8Ʈ 迭 .  160 Ʈ Ȯ
static u16 MDregister[50];  // 念 16Ʈ 迭 . 50  Ȯ
static HardwareSerial *port; //< Pointer to Serial class object

u8 debug8=0;
u16 debug16=0;
void comPut(u8 d);


/*******************************************************************************

  Function Name  : comFlush
   

*******************************************************************************/


void comFlush(void)
{
  __action_pointer = __ring_buffer_max-1;
  __save_pointer = 0;
}


/*******************************************************************************

  Function Name  : comLen
  ring buffer ִ   

*******************************************************************************/

u16 comLen(void)
{
  u16 i;
  if (__save_pointer>(__action_pointer+1)) {
    i=__save_pointer-__action_pointer-1;
    }
  else if (__save_pointer<(__action_pointer+1)) {
    i=__ring_buffer_max-__action_pointer+__save_pointer-1;
    }
  else {
    i=0;
    }
  return i;
}

/*******************************************************************************

  Function Name  : push_ringbuffer
    Ϳ push

*******************************************************************************/

void modbusFrameSearch(void);

void push_ringbuffer(u8 comdt)
{
  if (__modbusSwitch) {
    if (__modbusBlankCheck > 10) {  //<--  ڸ ϸ   (5mS  1 ϴ ī)
        comFlush(); // 50mS   , ۿ ִŴ  . (  ɼ )
        }
    __modbusBlankCheck = 0;
    }

  if(__save_pointer != __action_pointer) {  // ۰  ̻ ġ ʴ´.
    __ring_buffer[__save_pointer]=comdt;
    __save_pointer++;
    if(__save_pointer>=__ring_buffer_max) {
      __save_pointer=0;
      }
  }
  if (__modbusSwitch) modbusFrameSearch(); // ش ä  Ȱȭ Ǿ óش.
}

/*******************************************************************************

  Function Name  : read_ringbuffer
    Ϳ ϳ read

*******************************************************************************/

u8 read_ringbuffer(void)
{
  __action_pointer++;
  if(__action_pointer >= __ring_buffer_max){
    __action_pointer=0;
    }
  return(__ring_buffer[__action_pointer]);
}

/*******************************************************************************

  USART0  ͷƮ

*******************************************************************************/

ISR(USART1_RX_vect)
{
	char data = UDR1;
	//Serial.println(data,HEX);
  push_ringbuffer(data);  //  ʹ ۿ .
}

/*******************************************************************************

  Ÿ̸2 ÷ο ͷƮ (10mS)

*******************************************************************************/

void timer3_init(void)
{
	TIMSK3 |= 0x01;	//TOV interrupt set.
}

void modbusMainProcessing(void);

ISR(TIMER3_OVF_vect)
{
  static unsigned char count_cycle=0;

  count_cycle = (count_cycle + 1) % 2;

  if(!count_cycle)
  {
	if (__modbusFoundFrame) {
	  __modbusIntervalCounter++;
	  if (__modbusIntervalCounter > __modbusReturnInterval) {
		__modbusIntervalCounter = 0;
		__modbusFoundFrame = 0;
		modbusMainProcessing();
	  }
	 }

	if (__modbusBlankCheck < 0xffff) __modbusBlankCheck++;
  }

}

/*******************************************************************************

  ѹƮ ۽

*******************************************************************************/

void comPut(u8 d)
{
  while (!(UCSR1A & (1<<UDRE1))); //      
  UDR1 = d;
}

/*******************************************************************************

  Simple   ó

*******************************************************************************/

void mb_crc_compute(u8 rch);

u8 mb_get_byte_rtu(void)
{
  return read_ringbuffer();
}

u16 mb_get_word_rtu(void)
{
  u8 wh,wl;
  wh = read_ringbuffer();
  wl = read_ringbuffer();
  return (wh<<8)+wl;
}

void mb_inc_pointer(void)
{
  (void)read_ringbuffer();
}

void mb_put_byte_rtu(u8 dt)
{
  comPut(dt);
  mb_crc_compute(dt);
}

//
//  Bit б RTU (FC 0,1)
//
u8 mb_ncdtb[] = {1,2,4,8,16,32,64,128};

u8 mb_collectbits(u16 adr)
{
  u8 i,j,m=0;               // adr modbus ּ, ̰ ּҷ ȯϿ
  for (i=0;i<8;i++) {       // װ ִ Ʈ 8 о, ѹƮ ͷ ϼش.
    j = __modbusBitBuffer[adr>>3];
    if (j & mb_ncdtb[adr & 7]) m |= mb_ncdtb[i];
    adr++;
    }
  return m;
}

void mbcmd_read_bit_rtu(u8 cmd)
{
  u8 i,j,bln;
  u16 stadr,ln;
  stadr = mb_get_word_rtu(); // Start Address
  ln = mb_get_word_rtu(); // Length
  mb_inc_pointer();
  mb_inc_pointer(); // CRC ̹ üũǷ pass
  // ۽Ž
  if (__modbusBroadMode) return;    // Brodecast  ׳ 
  uchCRCHi = uchCRCLo = 0xff;   // CRC  start
  mb_put_byte_rtu(__modbusSlaveAdr);       // Slave Address
  mb_put_byte_rtu(cmd);         // Command
  bln = ln >> 3;
  if (ln & 7) bln++;          //   +1
  mb_put_byte_rtu(bln);           // Byte Count
  for (i=0; i<bln; i++) {
    j=mb_collectbits(stadr);
    mb_put_byte_rtu(j);
    stadr += 8;
    }
  i = uchCRCLo; // ٷ Ʒ uchCRCLo ǵ帮  Saveصд.
  mb_put_byte_rtu(uchCRCHi); // CRC
  mb_put_byte_rtu(i);
}

//
//  1 Bit  (FC 5)
//

void mbcmd_write_bit_single_rtu()
{
  u8 i;
  u16 stadr,realadr,val;
  stadr = mb_get_word_rtu(); // Start Address
  val = mb_get_word_rtu(); // Write Value
  mb_inc_pointer(); // CRC ̹ üũǷ pass
  mb_inc_pointer();

  debug16 = stadr;
  debug8 = val;

  realadr = stadr >> 3;
  if (val) __modbusBitBuffer[realadr] |= mb_ncdtb[stadr & 7];
  else __modbusBitBuffer[realadr] &= ~mb_ncdtb[stadr & 7];
  // ۽Ž
  if (__modbusBroadMode) return;    // Brodecast  ׳ 
  uchCRCHi = uchCRCLo = 0xff;   // CRC  start
  mb_put_byte_rtu(__modbusSlaveAdr);       // Slave Address
  mb_put_byte_rtu(5);           // Command
  mb_put_byte_rtu(stadr >> 8);
  mb_put_byte_rtu(stadr);
  mb_put_byte_rtu(val >> 8);
  mb_put_byte_rtu(val);
  i = uchCRCLo;
  mb_put_byte_rtu(uchCRCHi); // CRC
  mb_put_byte_rtu(i);
}

//
//  MODBUS RTU Word Read  (FC 3, 4)
//

void mbcmd_read_word_rtu(u8 cmd)
{
  u8 i;
  u16 stadr,ln,li,dt;
  stadr = mb_get_word_rtu(); // Start Address
  ln = mb_get_word_rtu(); // Length
  mb_inc_pointer();
  mb_inc_pointer();   // CRC ̹ üũǾǷ pass
  //
  //  Send Start
  //
  if (__modbusBroadMode) return;    // Brodecast  ׳ 
  uchCRCHi = uchCRCLo = 0xff;   // CRC  start
  mb_put_byte_rtu(__modbusSlaveAdr);       // Slave Address
  mb_put_byte_rtu(cmd);         // Command
  i = ln << 1;
  mb_put_byte_rtu(i);           // Byte Count

  for (li=0; li<ln; li++) {
    dt = __modbusWordBuffer[stadr++];
    mb_put_byte_rtu(dt >> 8); // High
    mb_put_byte_rtu(dt); // Low
    }
  i = uchCRCLo;
  mb_put_byte_rtu(uchCRCHi); // CRC
  mb_put_byte_rtu(i);
}

//
//    1常  (FC 6)
//

void mbcmd_write_word_single_rtu()
{
  u8 i;
  u16 stadr,val;
  stadr = mb_get_word_rtu(); // Start Address
  val = mb_get_word_rtu(); // Write Value
  mb_inc_pointer();
  mb_inc_pointer();   // CRC ̹ üũǾǷ pass
  __modbusWordBuffer[stadr] = val;

  if (__modbusBroadMode) return;    // Brodecast  ׳ 
  uchCRCHi = uchCRCLo = 0xff;   // CRC  start
  mb_put_byte_rtu(__modbusSlaveAdr);       // Slave Address
  mb_put_byte_rtu(6);           // Command
  mb_put_byte_rtu(stadr >> 8);
  mb_put_byte_rtu(stadr);
  mb_put_byte_rtu(val >> 8);
  mb_put_byte_rtu(val);
  i = uchCRCLo; // ٷ Ʒ uchCRCLo ǵ帮  Saveصд.
  mb_put_byte_rtu(uchCRCHi); // CRC
  mb_put_byte_rtu(i);
}


//
//   Bit  RTU (FC 15)
//

void mb_writebits(u16 adr, u8 val, u8 ln)
{
  u8 i,m;
  if (ln > 7) m=8;
    else m=ln;   // 15 쵵 8  ó
  for (i=0;i<m;i++) { // 8 ( 8 ̸) 鼭, buffer  Ѵ.
    if (val & mb_ncdtb[i]) // (adr byte巹 bit巹  ԵǾ ִ.)
      __modbusBitBuffer[adr >> 3] |= mb_ncdtb[adr & 7];
    else
      __modbusBitBuffer[adr >> 3] &= ~mb_ncdtb[adr & 7];
    adr++;
    }
}

void mbcmd_write_bit_multiple_rtu()
{
  u8 i,j,cnt;
  u16 stadr,ln,lnsave,stadr_save;
  stadr_save = stadr = mb_get_word_rtu(); // Start Address
  lnsave = ln = mb_get_word_rtu(); // Length
  cnt = mb_get_byte_rtu(); // byte count
  for (i=0; i<cnt; i++) {
    j = mb_get_byte_rtu(); // value
    mb_writebits(stadr, j, ln);
    stadr += 8;
    ln -= 8;
    }
  mb_inc_pointer();
  mb_inc_pointer();     // CRC ̹ üũǷ pass
  // ۽Ž
  if (__modbusBroadMode) return;    // Brodecast  ׳ 
  uchCRCHi = uchCRCLo = 0xff;   // CRC  start
  mb_put_byte_rtu(__modbusSlaveAdr);       // Slave Address
  mb_put_byte_rtu(15);         // Command
  mb_put_byte_rtu(stadr_save >> 8);
  mb_put_byte_rtu(stadr_save);
  mb_put_byte_rtu(lnsave >> 8);
  mb_put_byte_rtu(lnsave);
  i = uchCRCLo; // ٷ Ʒ uchCRCLo ǵ帮  Saveصд.
  mb_put_byte_rtu(uchCRCHi); // CRC
  mb_put_byte_rtu(i);
}

//
//       RTU (FC 16)
//

void mbcmd_write_word_multiple_rtu()
{
  u8 j;
  u16 stadr,realadr,val,ln,i;
  realadr = stadr = mb_get_word_rtu(); // Start Address
  ln = mb_get_word_rtu(); // length
  mb_inc_pointer(); // byte count
  for (i=0;i<ln;i++) {
    val = mb_get_word_rtu(); // Write Value
    __modbusWordBuffer[realadr++] = val;      // ⼭ Write 
    }
  mb_inc_pointer();
  mb_inc_pointer(); // CRC ̹ üũǷ pass
  // ۽Ž
  if (__modbusBroadMode) return;    // Brodecast  ׳ 
  uchCRCHi = uchCRCLo = 0xff;   // CRC  start
  mb_put_byte_rtu(__modbusSlaveAdr);       // Slave Address
  mb_put_byte_rtu(16);           // Command
  mb_put_byte_rtu(stadr >> 8);
  mb_put_byte_rtu(stadr);
  mb_put_byte_rtu(ln >> 8);
  mb_put_byte_rtu(ln);
  j = uchCRCLo; // ٷ Ʒ uchCRCLo ǵ帮  Saveصд.
  mb_put_byte_rtu(uchCRCHi); // CRC
  mb_put_byte_rtu(j);
}


/*******************************************************************************

  CRC16

*******************************************************************************/

const u8 auchCRCH[]  =  {
0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41, 0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1, 0x81,
0x40, 0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1, 0x81, 0x40, 0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0,
0x80, 0x41, 0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1, 0x81, 0x40, 0x00, 0xC1, 0x81, 0x40, 0x01,
0xC0, 0x80, 0x41, 0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41, 0x01, 0xC0, 0x80, 0x41,
0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1, 0x81, 0x40, 0x00, 0xC1, 0x81,
0x40, 0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41, 0x01, 0xC0,
0x80, 0x41, 0x00, 0xC1, 0x81, 0x40, 0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41, 0x01,
0xC0, 0x80, 0x41, 0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1, 0x81, 0x40,
0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41, 0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1, 0x81,
0x40, 0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0,
0x80, 0x41, 0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1, 0x81, 0x40, 0x00, 0xC1, 0x81, 0x40, 0x01,
0xC0, 0x80, 0x41, 0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41,
0x00, 0xC1, 0x81, 0x40, 0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1, 0x81,
0x40, 0x01, 0xC0, 0x80, 0x41, 0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0,
0x80, 0x41, 0x00, 0xC1, 0x81, 0x40, 0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41, 0x01,
0xC0, 0x80, 0x41, 0x00, 0xC1, 0x81, 0x40, 0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41,
0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41, 0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1, 0x81,0x40};

const u8 auchCRCL[] = {
0x00, 0xC0, 0xC1, 0x01, 0xC3, 0x03, 0x02, 0xC2, 0xC6, 0x06, 0x07, 0xC7, 0x05, 0xC5, 0xC4,
0x04, 0xCC, 0x0C, 0x0D, 0xCD, 0x0F, 0xCF, 0xCE, 0x0E, 0x0A, 0xCA, 0xCB, 0x0B, 0xC9, 0x09,
0x08, 0xC8, 0xD8, 0x18, 0x19, 0xD9, 0x1B, 0xDB, 0xDA, 0x1A, 0x1E, 0xDE, 0xDF, 0x1F, 0xDD,
0x1D, 0x1C, 0xDC, 0x14, 0xD4, 0xD5, 0x15, 0xD7, 0x17, 0x16, 0xD6, 0xD2, 0x12, 0x13, 0xD3,
0x11, 0xD1, 0xD0, 0x10, 0xF0, 0x30, 0x31, 0xF1, 0x33, 0xF3, 0xF2, 0x32, 0x36, 0xF6, 0xF7,
0x37, 0xF5, 0x35, 0x34, 0xF4, 0x3C, 0xFC, 0xFD, 0x3D, 0xFF, 0x3F, 0x3E, 0xFE, 0xFA, 0x3A,
0x3B, 0xFB, 0x39, 0xF9, 0xF8, 0x38, 0x28, 0xE8, 0xE9, 0x29, 0xEB, 0x2B, 0x2A, 0xEA, 0xEE,
0x2E, 0x2F, 0xEF, 0x2D, 0xED, 0xEC, 0x2C, 0xE4, 0x24, 0x25, 0xE5, 0x27, 0xE7, 0xE6, 0x26,
0x22, 0xE2, 0xE3, 0x23, 0xE1, 0x21, 0x20, 0xE0, 0xA0, 0x60, 0x61, 0xA1, 0x63, 0xA3, 0xA2,
0x62, 0x66, 0xA6, 0xA7, 0x67, 0xA5, 0x65, 0x64, 0xA4, 0x6C, 0xAC, 0xAD, 0x6D, 0xAF, 0x6F,
0x6E, 0xAE, 0xAA, 0x6A, 0x6B, 0xAB, 0x69, 0xA9, 0xA8, 0x68, 0x78, 0xB8, 0xB9, 0x79, 0xBB,
0x7B, 0x7A, 0xBA, 0xBE, 0x7E, 0x7F, 0xBF, 0x7D, 0xBD, 0xBC, 0x7C, 0xB4, 0x74, 0x75, 0xB5,
0x77, 0xB7, 0xB6, 0x76, 0x72, 0xB2, 0xB3, 0x73, 0xB1, 0x71, 0x70, 0xB0, 0x50, 0x90, 0x91,
0x51, 0x93, 0x53, 0x52, 0x92, 0x96, 0x56, 0x57, 0x97, 0x55, 0x95, 0x94, 0x54, 0x9C, 0x5C,
0x5D, 0x9D, 0x5F, 0x9F, 0x9E, 0x5E, 0x5A, 0x9A, 0x9B, 0x5B, 0x99, 0x59, 0x58, 0x98, 0x88,
0x48, 0x49, 0x89, 0x4B, 0x8B, 0x8A, 0x4A, 0x4E, 0x8E, 0x8F, 0x4F, 0x8D, 0x4D, 0x4C, 0x8C,
0x44, 0x84, 0x85, 0x45, 0x87, 0x47, 0x46, 0x86, 0x82, 0x42, 0x43, 0x83, 0x41, 0x81, 0x80,0x40};

void mb_crc_compute(u8 rch)
{
  uINDEX = uchCRCHi ^ rch;
  uchCRCHi = uchCRCLo ^ auchCRCH[uINDEX];
  uchCRCLo = auchCRCL[uINDEX];
}

//
//  CRC16  Լ, byte ̿ ϴ Ʈŭ ѵ   
//

u16 getCrc(u8 * targetArray, u16 datalength)			//  getCrc
{
  u16 d;
  uchCRCHi = uchCRCLo = 0xff;   // CRC  start
  for (d=0; d<datalength; d++) {
    mb_crc_compute(targetArray[d]);
    }
  d = (uchCRCHi << 8) + uchCRCLo;
  return d;
}

u16 getCrc_16(u16 * targetArray, u16 datalength)		// integerŸԿ ϴ getCrcԴϴ.
{
  u16 d;
  uchCRCHi = uchCRCLo = 0xff;   // CRC  start
  for (d=0; d<datalength; d++) {
    mb_crc_compute(targetArray[d]);
    }
  d = (uchCRCHi << 8) + uchCRCLo;
  return d;
}
/*******************************************************************************

  Function Name  : startModbus
   MAIN ó

*******************************************************************************/

//  Register () ۹
//  Coil (Ʈ) ۹ ǳ ޴´.
//    뷫 3mS

void startSimpleModbus(u8 modslaveadr, u16 * modbusBufferRegister, u8 * modbusBufferCoil)
{
  __modbusSlaveAdr = modslaveadr;
  __modbusSwitch = 1; // On
  __modbusWordBuffer = modbusBufferRegister;
  __modbusBitBuffer = modbusBufferCoil;
  sei();
}

//
// 1Ʈ  Ǿ,  RTU  ϼ ( CRC տſ ġ)ϴ θ Ѵ.
//

void modbusFrameSearch(void)
{
  u8 uch, ucl, bh, bl;
  u16 mclen, i;
  u16 uix;
  u16 save_pointer;
  mclen = comLen(); // ŵ Ʈ 

  if (mclen < 8) return; // 8Ʈ   ڸ Ƿ ٷ 

  uch = ucl = 0xff;       //  CRC ϱ ..  ̰  ۸ ĵѴ.
  save_pointer = __action_pointer; //  ͸ ī
  for (i = 0; i< mclen-2; i++) {
    uix = uch ^ mb_get_byte_rtu(); // __action_pointer ǵ帮Ƿ ߿ ־ Ѵ.
    uch = ucl ^ auchCRCH[uix];
    ucl = auchCRCL[uix];
    }
  bh = mb_get_byte_rtu(); //̰ CRC
  bl = mb_get_byte_rtu();
  __action_pointer = save_pointer; // 

#ifdef MONITOR_CRC
  Serial.print("")
#endif
  if ((bh == uch) && (bl == ucl)) __modbusFoundFrame = 1; // ߰!

}

void modbusMainProcessing(void)
{
  u8 fc,sladr;
  sladr = mb_get_byte_rtu(); // ̺ 巹 о
  if (sladr == 0) {
    __modbusBroadMode = 1; // ̺ 巹 0̸ εɽƮ  = 1
    }
  else {
    if (sladr != __modbusSlaveAdr) { // ̺ 巹 ġ ,  Ŭ 
      comFlush();
      return;
      }
   }

  fc = mb_get_byte_rtu(); // ڵ о

  switch (fc) {
  case 1:
  case 2:
    mbcmd_read_bit_rtu(fc);
    break;
  case 3:
  case 4:
    mbcmd_read_word_rtu(fc);
    break;
  case 5:
    mbcmd_write_bit_single_rtu();
    break;
  case 6:
    mbcmd_write_word_single_rtu();
    break;
  case 15:
    mbcmd_write_bit_multiple_rtu();
    break;
  case 16:
    mbcmd_write_word_multiple_rtu();
    break;
  default:
    comFlush(); //  FC(ڵ)ϰ, Ŭ
    return;
    }
}


//
//  巹  Ʈ ¸ о Լ
// a = coil(9); // ̷ ϸ 00009 Ʈ 巹ġ ãƼ ش Ʈ о´.


u8 coil(u16 MDBSadr)
{
    MDBSadr--;
    if (MDcoil[MDBSadr>>3] & mb_ncdtb[MDBSadr & 7]) return 1;
    return 0;
}

//
//  巹 Ʈ ¸ 
// coilSet(9,0); // 00009巹 0 .
// coilSet(9,1); // 00009巹 1 .
//

void coilSet(u16 MDBSadr, u8 MDBSdata)
{
    u16 arrayindex;
    MDBSadr--;
    arrayindex = MDBSadr>>3; // 迭 ġ
    if (MDBSdata==0) {
        MDcoil[arrayindex] &= ~mb_ncdtb[MDBSadr & 7];
        }
    else {
        MDcoil[arrayindex] |= mb_ncdtb[MDBSadr & 7];
        }
}

//
//  巹 () о´.
//  巹 ܼ 40001  迭 ġ ȴ.
//

u16 getReg(u16 MDBSadr)
{
    return MDregister[MDBSadr - 40001];
}

//
//  巹 () ִ´.
//  巹 ܼ 40001  迭 ġ ȴ.
//


void setReg(u16 MDBSadr, u16 MDBSdata)
{
    MDregister[MDBSadr - 40001] = MDBSdata;
}

/*========================Simple modbus end===============================*/
void _delay(u16 i)
{
 u16 j,k;
 for (j=0;j<i;j++) {
  for (k=0;k<300;k++) wdt_reset();
  }
}

void usart1init(u16 baud)
{
  unsigned long i;

  DDRK = 0xff;
  timer3_init(); // Ÿ̸2  ʱȭ (sys_tick )

  i = (unsigned long)(((XTAL/baud)/16)-1); // U2X x2
  UBRR1H = (u8)(i>>8);
  UBRR1L = (u8)i;

  UCSR1B |= (1<<RXCIE1 | 1<<RXEN1 | 1<<TXEN1);
  UCSR1C |= (1 << UCSZ10) | (1 << USBS1); // 8BIT, 1STOP BIT, NO PARITY
}



#endif /* SIMPLEMODBUSRTU_MEGA2560_H_ */
