﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ComfileTech.ComfilePi.IO
{
    public class AnalogOutput : IDisposable
    {
        public enum ChannelID
        {
            D1 = 0,
            D2 = 1
        }

        public AnalogOutput(ChannelID channel)
        {
            MCP4725.AddressPins address = MCP4725.AddressPins.b000;

            switch (channel)
            {
                case ChannelID.D1:
                    address = MCP4725.AddressPins.b010;
                    break;
                case ChannelID.D2:
                    address = MCP4725.AddressPins.b011;
                    break;
                default:
                    break;
            }

            _i2c = new MCP4725(address);
        }

        MCP4725 _i2c;

        public ChannelID Channel
        {
            get
            {
                switch(_i2c.Address)
                {
                    case MCP4725.AddressPins.b010:
                        return ChannelID.D1;
                    case MCP4725.AddressPins.b011:
                        return ChannelID.D2;
                    default:
                        throw new NotImplementedException($"MCP4725 address \"{_i2c.Address}\" is not implemented.");
                }
            }
        }

        public ushort State
        {
            get { return _i2c.Read(); }
            set { _i2c.Write(MCP4725.PowerDown.Normal, value); }
        }

        #region IDisposable Support
        private bool disposedValue = false;

        protected virtual void Dispose(bool disposing)
        {
            if (!disposedValue)
            {
                if (disposing)
                {
                    _i2c.Dispose();
                }

                _i2c = null;

                disposedValue = true;
            }
        }

        public void Dispose()
        {
            Dispose(true);
        }
        #endregion
    }
}
