﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ComfileTech.ComfilePi.IO
{
    public class CP_IO22 : ICP_IO, IHasDigitalInputs, IHasDigitalOutputs
    {
        public CP_IO22()
        {
            _inputs = new Dictionary<Pin, DigitalInput>();
            _outputs = new Dictionary<Pin, DigitalOutput>();

            foreach (var pin in (IEnumerable<Pin>)Enum.GetValues(typeof(Pin)))
            {
                if ((pin >= Pin.GPIO04 && pin <= Pin.GPIO13) || pin == Pin.GPIO16)
                {
                    var input = new DigitalInput(pin);
                    _inputs.Add(input.Pin, input);
                }

                if (pin >= Pin.GPIO17 && pin <= Pin.GPIO27)
                {
                    var output = new DigitalOutput(pin);
                    _outputs.Add(output.Pin, output);
                }
            }
        }

        readonly Dictionary<Pin, DigitalInput> _inputs;
        public IReadOnlyDictionary<Pin, DigitalInput> DigitalInputs => _inputs;

        readonly Dictionary<Pin, DigitalOutput> _outputs;
        public IReadOnlyDictionary<Pin, DigitalOutput> DigitalOutputs => _outputs;
    }
}
