﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ComfileTech.ComfilePi.IO
{
    public class CP_IO22_A4_2 : CP_IO22, IHasAnalogInputs, IHasAnalogOutputs, IDisposable
    {
        public CP_IO22_A4_2()
            : base()
        {
            _adc = new ADS1115();
            _analogInputs = new Dictionary<AnalogInput.ChannelID, AnalogInput>();
            foreach(var channel in Enum.GetValues(typeof(AnalogInput.ChannelID)))
            {
                var input = new AnalogInput(_adc, (AnalogInput.ChannelID)channel);
                _analogInputs.Add(input.Channel, input);
            }

            _analogOutputs = new Dictionary<AnalogOutput.ChannelID, AnalogOutput>();
            foreach (var channel in Enum.GetValues(typeof(AnalogOutput.ChannelID)))
            {
                var output = new AnalogOutput((AnalogOutput.ChannelID)channel);
                _analogOutputs.Add(output.Channel, output);
            }

        }

        ADS1115 _adc;

        readonly Dictionary<AnalogInput.ChannelID, AnalogInput> _analogInputs;
        public IReadOnlyDictionary<AnalogInput.ChannelID, AnalogInput> AnalogInputs => _analogInputs;

        readonly Dictionary<AnalogOutput.ChannelID, AnalogOutput> _analogOutputs;
        public IReadOnlyDictionary<AnalogOutput.ChannelID, AnalogOutput> AnalogOutputs => _analogOutputs;

        #region IDisposable Support
        private bool disposedValue = false;

        protected virtual void Dispose(bool disposing)
        {
            if (!disposedValue)
            {
                if (disposing)
                {
                    _adc.Dispose();

                    foreach(var dac in _analogOutputs)
                    {
                        dac.Value.Dispose();
                    }
                }

                _adc = null;
                _analogOutputs.Clear();

                disposedValue = true;
            }
        }

        public void Dispose()
        {
            Dispose(true);
        }
        #endregion
    }
}
