﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ComfileTech.ComfilePi.IO
{
    public class MCP4725 : I2CDevice
    {
        /// <summary>
        /// Corresponds to A2 A1 A0
        /// </summary>
        public enum AddressPins
        {
            b000 = 0,
            b001 = 1,
            b010 = 2,
            b011 = 3,
            b100 = 4,
            b101 = 5,
            b110 = 6,
            b111 = 7
        }

        public enum PowerDown
        {
            Normal = 0b00,
            Ohm_1k = 0b01,
            Ohm_100k = 0b10,
            Ohm_500k = 0b11
        }

        public MCP4725(AddressPins address)
            : base((byte)(0b110_0000 | (int)address))
        {
            _address = address;
        }

        AddressPins _address;
        public AddressPins Address => _address;

        public void Write(PowerDown pd, ushort value)
        {
            value = (ushort)
            (
                (0b00 << 14)                  // Fast Mode Command
                | ((int)pd << 12)             // Power down bits
                | (value & 0b1111_1111_1111)  // only 12 bits
            );

            var bytes = BitConverter.GetBytes(value);
            Array.Reverse(bytes);
            
            Write(bytes);
        }

        public new ushort Read()
        {
            byte[] buffer = new byte[3];
            Read(buffer);

            // The first byte is just configuration data.
            // Data is in the least significant 2 bytes.
            // Only 12 bits. Shift away least significant 4 bits
            Array.Reverse(buffer);
            return (ushort)(BitConverter.ToUInt16(buffer, 0) >> 4);
        }
    }
}
