﻿using Modbus.Device;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO.Ports;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace SimpleModbusExample
{
    public partial class Form1 : Form
    {
        const int SLAVE_ADDRESS = 1;
        const int COIL_ADDRESS = 32;

        public Form1()
        {
            InitializeComponent();
        }

        SerialPort _port;
        ModbusSerialMaster _master;

        private void Form1_Load(object sender, EventArgs e)
        {
            // Intialize serial port
            string portName = Environment.OSVersion.Platform == PlatformID.Win32NT ? "COM1" : "/dev/serial0";
            _port = new SerialPort(portName, 115200);
            _port.ReadTimeout = 100;
            _port.WriteTimeout = 100;
            _port.Open();

            // Initialize Modbus master
            _master = ModbusSerialMaster.CreateRtu(_port);

            // Read the current state of the output
            ReadState();
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            // Destroy Modbus master
            _master.Dispose();
            _master = null;

            // Destroy serial port
            _port.Close();
            _port.Dispose();
            _port = null;
        }

        private void OnButton_Click(object sender, EventArgs e)
        {
            // Turn output ON
            _master.WriteSingleCoil(SLAVE_ADDRESS, COIL_ADDRESS, true);
            
        }

        private void OffButton_Click(object sender, EventArgs e)
        {
            // Turn output OFF
            _master.WriteSingleCoil(SLAVE_ADDRESS, COIL_ADDRESS, false);
        }

        void ReadState()
        {
            // Read the current state of the output
            var state = _master.ReadCoils(SLAVE_ADDRESS, COIL_ADDRESS, 1);

            // Update the UI
            if (state[0])
            {
                StateLabel.Text = "On";
            }
            else
            {
                StateLabel.Text = "Off";
            }
        }

        private void ReadStateButton_Click(object sender, EventArgs e)
        {
            // Read the current state of the output
            ReadState();
        }
    }
}
