import QtQuick 2.7
import QtQuick.Window 2.2
import QtQuick.Extras 1.4
import QtQuick.Controls 2.1
import QtQuick.Controls.Styles 1.4
import QtQuick.Controls.Material 2.0
import QtQuick.Controls.Universal 2.0

Window {
    id: window
    visible: true
    width: 800
    height: 480
    color: "#404040"
    title: qsTr("Modbus Example")

    StatusIndicator {
        id: statusIndicator0
        objectName: "statusIndicator0"
        x: 27
        y: 62
        width: 150
        height: 150
    }

    StatusIndicator {
        id: statusIndicator1
        objectName: "statusIndicator1"
        x: 225
        y: 62
        width: 150
        height: 150
        color: "#ffff00"
    }

    StatusIndicator {
        id: statusIndicator2
        objectName: "statusIndicator2"
        x: 420
        y: 62
        width: 150
        height: 150
        color: "#00ff00"
    }

    StatusIndicator {
        id: statusIndicator3
        objectName: "statusIndicator3"
        x: 615
        y: 62
        width: 150
        height: 150
        color: "#0000ff"
    }

    ToggleButton {
        id: toggleButton0
        x: 27
        y: 296
        width: 150
        height: 150
        objectName: "toggleButton0"
        text: qsTr("")
        checked: false

        style: ToggleButtonStyle {
            checkedGradient: Gradient {
                GradientStop { position: 0.0; color: "#FF0000" }
            }
            checkedDropShadowColor: "#FF0000"

            uncheckedGradient: Gradient {
                GradientStop { position: 0.0; color: "#404040" }
            }
            uncheckedDropShadowColor: "#00000000"
        }

        signal click(bool checked)

        MouseArea {
            anchors.fill: parent
            onPressed: {
                parent.checked = !parent.checked
                parent.click(parent.checked)
            }
        }
    }

    ToggleButton {
        id: toggleButton1
        x: 225
        y: 293
        width: 150
        height: 150
        text: qsTr("")
        objectName: "toggleButton1"
        checked: false

        style: ToggleButtonStyle {
            checkedGradient: Gradient {
                GradientStop { position: 0.0; color: "#FFFF00" }
            }
            checkedDropShadowColor: "#FFFF00"

            uncheckedGradient: Gradient {
                GradientStop { position: 0.0; color: "#404040" }
            }
            uncheckedDropShadowColor: "#00000000"
        }

        signal click(bool checked)

        MouseArea {
            anchors.fill: parent
            onPressed: {
                parent.checked = !parent.checked
                parent.click(parent.checked)
            }
        }
    }

    ToggleButton {
        id: toggleButton2
        x: 420
        y: 293
        width: 150
        height: 150
        text: qsTr("")
        objectName: "toggleButton2"
        checked: false

        style: ToggleButtonStyle {
            checkedGradient: Gradient {
                GradientStop { position: 0.0; color: "#00FF00" }
            }
            checkedDropShadowColor: "#00FF00"

            uncheckedGradient: Gradient {
                GradientStop { position: 0.0; color: "#404040" }
            }
            uncheckedDropShadowColor: "#00000000"
        }

        signal click(bool checked)

        MouseArea {
            anchors.fill: parent
            onPressed: {
                parent.checked = !parent.checked
                parent.click(parent.checked)
            }
        }
    }

    ToggleButton {
        id: toggleButton3
        x: 615
        y: 288
        width: 150
        height: 150
        text: qsTr("")
        objectName: "toggleButton3"
        checked: false

        style: ToggleButtonStyle {
            checkedGradient: Gradient {
                GradientStop { position: 0.0; color: "#0000FF" }
            }
            checkedDropShadowColor: "#0000FF"

            uncheckedGradient: Gradient {
                GradientStop { position: 0.0; color: "#404040" }
            }
            uncheckedDropShadowColor: "#00000000"
        }

        signal click(bool checked)

        MouseArea {
            antialiasing: false
            smooth: true
            anchors.fill: parent
            onPressed: {
                parent.checked = !parent.checked
                parent.click(parent.checked)
            }
        }
    }

    Text {
        id: text1
        x: 274
        y: 14
        width: 252
        height: 31
        color: "#ffffff"
        text: qsTr("INPUTS")
        font.underline: false
        verticalAlignment: Text.AlignVCenter
        horizontalAlignment: Text.AlignHCenter
        font.pixelSize: 24
    }

    Rectangle{
        x: 20
        y: 42
        color: "#FFFFFF"
        width: 761
        height: 3
    }

    Text {
        id: text2
        x: 274
        y: 245
        width: 252
        height: 31
        color: "#ffffff"
        text: qsTr("OUTPUTS")
        verticalAlignment: Text.AlignVCenter
        font.underline: false
        horizontalAlignment: Text.AlignHCenter
        font.pixelSize: 24
    }

    Rectangle {
        x: 20
        y: 273
        width: 761
        height: 3
        color: "#ffffff"
    }
}
